#!/usr/bin/env python3
# -*- coding: utf-8 -*-

"""
\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
Reprise des calculs planck Maple sous wet_03
\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
--> C
-->
-->
\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
--------------------------------------------------------------------------------
CONSIGNES :



--------------------------------------------------------------------------------
"""

# ------------------------------------------------------------------------------
# Initialisation des librairies qui contiennent les fonctions usuelles
# ------------------------------------------------------------------------------
import matplotlib.pyplot as plt
import numpy as np
from math import exp, expm1

plt.clf()


# définition des constantes physiques pour planck :

c=299792458.0            # vitesse de la lumière (ms^-1)
h=6.6260687652*10**(-34)    # constante de Planck (Js)
k=1.380650324*10**(-23)     # constante de Boltzmann (JK^-1)
Pi=3.141592654
nbpts=100000         # nombre de points pour le trace
couleur=['#cb3c2e','#9443e3','#4366e3','#43e396','#b8533a','#5e966a']

Tc=[]
Tc.append(0.0)             # Températures en degrés Celsius
Tc.append(37.0)
Tc.append(50.0)
Tc.append(100.0)
lamin=0.0          # longueur d'onde minimale pour le tracé en micromètre
lamax=1000.0         # longueur d'onde maximale pour le tracé en micromètre
n=len(Tc)          # nombre de courbes
delta_la=(lamax-lamin)/(nbpts-1)
# Conversion des températures en Kelvin
Tk=[]
for i in range(0,n):
    Tk.append(Tc[i]+273.15)
def planck_fonc(i,la):       # calcul de la fonction de Planck
 #   return 2*Pi*h*c**2/((la*10**(-6))**5*(expm1(h*c/(la*10**(-6)*k*Tk[i]))-1))
    if la>10**(-200) :
       x=h*c/(la*10**(-6)*k*Tk[i])
       if x<700 :
           return 2*Pi*h*c**2/((la*10**(-6))**5*(expm1(x)))  # exp(x)-1
       else:
            return 0
    else:
        return 0
def planck_wien_fonc(la):    # ligne des maxima
 #   return 2*Pi*h*c**2/((la*10**(-6))**5*(expm1(h*c/(la*10**(-6)*k*(2898.0/la)))-1))
    if la>10**(-200):
        x=h*c/(la*10**(-6)*k*(2898.0/la))
        if x<700 :
            return 2*Pi*h*c**2/((la*10**(-6))**5*(expm1(x)))
        else :
            return 0
    else:
        return 0

planck=[]
la_var=[]
for ii in range(0,nbpts):
    la_var.append(lamin+delta_la*ii)
for i in range(0,n):
    planck.append([])
    for ii in range(0,nbpts):
        planck[i].append(planck_fonc(i,la_var[ii]))

planck_wien=[]
for ii in range(0,nbpts):
    planck_wien.append(planck_wien_fonc(la_var[ii]))

# Titre du graphe
#
plt.clf()
#plt.axis([0,int(10*max(la_var))/10+0.1,int(min(min(planck)))-1,int(max(max(planck)))])
plt.axis([0,max(la_var)/20,int(min(min(planck)))-1,int(max(max(planck)))])

for i in range(0,n):
    plt.plot(la_var,planck[i],couleur[i%6], label = "planck "+str(Tc[i])+"°C")
plt.plot(la_var,planck_wien,"g", label = "Ligne des max")


#   Affiche la grille
plt.grid()

#   Nom des grandeurs sur les axes
plt.xlabel("longueur d'onde en micromètres")
plt.ylabel("Puissance rayonnée")

#   Titre du graphe
plt.title("Loi de Planck pour le rayonnement")

#   Affichage des noms des courbes et du graphe
plt.legend()
plt.show()
# calcul de l'integrale sur la longueur d'onde. Comparaison
# a sigma T 4
sigma_stef=5.670374*10**(-8)
integrale=0.0
for ii in range(0,nbpts):
    integrale=integrale+planck[0][ii]
integrale =integrale*delta_la*10**(-6)
puiss_t4=sigma_stef*Tk[0]*Tk[0]*Tk[0]*Tk[0]
print("integrale = ")
print(integrale)
print(" ")
print("sigma T**4 = ")
print(puiss_t4)

